CONTAINER Mtachyonmaterial
{
	NAME Mtachyonmaterial;

	GROUP
	{
		MATPREVIEW TACHYON_MATERIAL_PREVIEW { OPEN; MIN_WIDTH 100; MIN_HEIGHT 100; NO_SIZE_POPUP; }
	}

	INCLUDE Mbase;

	GROUP Obaselist
	{
		GROUP
		{
			COLUMNS 2; MATEDCOLUMNS 1;

			BOOL TACHYON_MATERIAL_USE_COLOR { PARENTMSG TACHYON_MATERIALGROUP_COLOR; }
			BOOL TACHYON_MATERIAL_USE_EMISSIVE { PARENTMSG TACHYON_MATERIALGROUP_EMISSIVE; }
			BOOL TACHYON_MATERIAL_USE_TRANSPARENCY { PARENTMSG TACHYON_MATERIALGROUP_TRANSPARENCY; }
			BOOL TACHYON_MATERIAL_USE_CLEARCOAT { PARENTMSG TACHYON_MATERIALGROUP_CLEARCOAT; }
			BOOL TACHYON_MATERIAL_USE_REFLECTANCE { PARENTMSG TACHYON_MATERIALGROUP_REFLECTANCE; }
			//BOOL TACHYON_MATERIAL_USE_ENVIRONMENT { PARENTMSG TACHYON_MATERIALGROUP_ENVIRONMENT; }
			BOOL TACHYON_MATERIAL_USE_BUMP { PARENTMSG TACHYON_MATERIALGROUP_BUMP; }
			BOOL TACHYON_MATERIAL_USE_NORMAL { PARENTMSG TACHYON_MATERIALGROUP_NORMAL; }
			BOOL TACHYON_MATERIAL_USE_DISPLACEMENT { PARENTMSG TACHYON_MATERIALGROUP_DISPLACEMENT; }
			BOOL TACHYON_MATERIAL_USE_MASK { PARENTMSG TACHYON_MATERIALGROUP_MASK; }
			COLOR TACHYON_MATERIAL_MAT_ID_COLOR { }
		} 
	}

	GROUP TACHYON_MATERIALGROUP_COLOR
	{
		DEFAULT 1;

		COLOR TACHYON_MATERIAL_DIFFUSE_COLOR { OPEN; }

		SEPARATOR {}

		LONG TACHYON_MATERIAL_DIFFUSE_TEXTURE_MODE
		{
			NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
			CYCLE
			{
				TACHYON_MATERIAL_MIX_MODE_BLEND;
				TACHYON_MATERIAL_MIX_MODE_ADD;
				//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
				TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
			}
		}

		REAL TACHYON_MATERIAL_DIFFUSE_TEXTURE_STRENGTH	{ NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; CUSTOMGUI REALSLIDER; }

        //----------------------------------------DIFFUSE SHADER----------------------------------------
        SHADERLINK TACHYON_MATERIAL_DIFFUSE_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
        GROUP
        {
            COLUMNS 3;

            BOOL TACHYON_MATERIAL_DIFFUSE_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

            LONG TACHYON_MATERIAL_DIFFUSE_SHADER_RESOLUTION
            {
                NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
                CUSTOMGUI QUICKTABRADIO;
                SCALE_H;
                ANIM OFF;

                CYCLE
                {
                    TACHYON_SHADER_RESOLUTION_LOW;
                    TACHYON_SHADER_RESOLUTION_MEDIUM;
                    TACHYON_SHADER_RESOLUTION_HIGH;
                };
            }

            BOOL TACHYON_MATERIAL_DIFFUSE_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
        }
        STATICTEXT TACHYON_MATERIAL_DIFFUSE_SHADER_RESOLUTION_TEXT { ANIM OFF; SCALE_H; }
        //BITMAPBUTTON TACHYON_MATERIAL_DIFFUSE_SHADER_LIVE_HINT { FIT_H; } // experimental live-icon
        //----------------------------------------DIFFUSE SHADER END----------------------------------------

		REAL TACHYON_MATERIAL_DIFFUSE_TEXTURE_BRIGHTNESS	{ NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_DIFFUSE_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_DIFFUSE_TEXTURE_GAMMA	{ NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		BOOL TACHYON_MATERIAL_DIFFUSE_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
	}

	GROUP TACHYON_MATERIALGROUP_CLEARCOAT
	{
		DEFAULT 1;

		REAL TACHYON_MATERIAL_CLEARCOAT_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }

		// REAL TACHYON_MATERIAL_CLEARCOAT_BASE_NORMAL_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }

		GROUP TACHYON_MATERIALGROUP_CLEARCOAT_GLOSSINESS
		{
			DEFAULT 1;
			LONG TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_ROUGH_SWITCH 
			{
			
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE 
				{
					TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_MODE;
					TACHYON_MATERIAL_REFLECTANCE_ROUGHNESS_MODE;
				};
			}

			REAL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_CLEARCOAT_ROUGHNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}

			SEPARATOR {}
			
			LONG TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_MODE
			{
				NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
				CYCLE
				{
					TACHYON_MATERIAL_MIX_MODE_BLEND;
					TACHYON_MATERIAL_MIX_MODE_ADD;
					//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
					TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
				}
			}
			REAL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

			//----------------------------------------CLEARCOAT GLOSSINESS SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------CLEARCOAT GLOSSINESS SHADER END----------------------------------------
			LONG TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_CHANNEL_SELECTION 
			{
				NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
				};
			}

			REAL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_CONTRAST { NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			BOOL TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
		}

		GROUP TACHYON_MATERIALGROUP_CLEARCOAT_NORMAL
		{
			DEFAULT 1;

			REAL TACHYON_MATERIAL_CLEARCOAT_NORMAL_BLEND { NAME TACHYON_MATERIAL_CLEARCOAT_NORMAL_BLEND; UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_CLEARCOAT_NORMAL_STRENGTH { NAME TACHYON_MATERIAL_NORMAL_STRENGTH; UNIT PERCENT; MINSLIDER -100.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			BOOL TACHYON_MATERIAL_CLEARCOAT_NORMAL_FLIP_RED { NAME TACHYON_MATERIAL_NORMAL_FLIP_RED; }
			BOOL TACHYON_MATERIAL_CLEARCOAT_NORMAL_FLIP_GREEN { NAME TACHYON_MATERIAL_NORMAL_FLIP_GREEN; }

			//----------------------------------------NORMAL SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_NORMAL_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------NORMAL SHADER END----------------------------------------
		}
	}

	GROUP TACHYON_MATERIALGROUP_REFLECTANCE
	{
		DEFAULT 1;

		GROUP TACHYON_MATERIALGROUP_FRESNEL_REFLECTANCE
		{
			DEFAULT 1;

			LONG TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW 
			{
			    CUSTOMGUI QUICKTABRADIO;
                SCALE_H;
                ANIM OFF;

				CYCLE 
				{
					TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_METALLIC;
					TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_SPECULAR;
					TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_HYBRID;
				}
			}

			GROUP TACHYON_MATERIALGROUP_SPECULARITY 
			{
				DEFAULT 1;

				COLOR TACHYON_MATERIAL_REFLECTANCE_COLOR { OPEN; }
				REAL TACHYON_MATERIAL_REFLECTANCE_BRIGHTNESS { UNIT PERCENT; MIN 0; MAX 100; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }

				SEPARATOR {}

				LONG TACHYON_MATERIAL_REFLECTANCE_TEXTURE_MODE
				{
					NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
					CYCLE
					{
						TACHYON_MATERIAL_MIX_MODE_BLEND;
						TACHYON_MATERIAL_MIX_MODE_ADD;
						//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
						TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
					}
				}
				REAL TACHYON_MATERIAL_REFLECTANCE_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

				//----------------------------------------SPECULAR SHADER----------------------------------------
				SHADERLINK TACHYON_MATERIAL_REFLECTANCE_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
				GROUP
				{
					COLUMNS 3;

					BOOL TACHYON_MATERIAL_REFLECTANCE_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

					LONG TACHYON_MATERIAL_REFLECTANCE_SHADER_RESOLUTION
					{
						NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
						CUSTOMGUI QUICKTABRADIO;
						SCALE_H;
						ANIM OFF;

						CYCLE
						{
							TACHYON_SHADER_RESOLUTION_LOW;
							TACHYON_SHADER_RESOLUTION_MEDIUM;
							TACHYON_SHADER_RESOLUTION_HIGH;
						};
					}

					BOOL TACHYON_MATERIAL_REFLECTANCE_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
				}
				STATICTEXT TACHYON_MATERIAL_REFLECTANCE_SHADER_RESOLUTION_TEXT { ANIM OFF; }
				//----------------------------------------SPECULAR SHADER END----------------------------------------

				REAL TACHYON_MATERIAL_REFLECTANCE_TEXTURE_BRIGHTNESS	{ NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
				REAL TACHYON_MATERIAL_REFLECTANCE_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
				REAL TACHYON_MATERIAL_REFLECTANCE_TEXTURE_GAMMA	{ NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
				BOOL TACHYON_MATERIAL_REFLECTANCE_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
			}

			GROUP TACHYON_MATERIALGROUP_METALNESS 
			{
				DEFAULT 1;

				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_VALUE { UNIT PERCENT; MIN 0; MAX 100; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }

				LONG TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_MODE
				{
					NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
					CYCLE
					{
						TACHYON_MATERIAL_MIX_MODE_BLEND;
						TACHYON_MATERIAL_MIX_MODE_ADD;
						//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
						TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
					}
				}
				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

				//----------------------------------------METALNESS SHADER----------------------------------------
				SHADERLINK TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
				GROUP
				{
					COLUMNS 3;

					BOOL TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

					LONG TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_RESOLUTION
					{
						NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
						CUSTOMGUI QUICKTABRADIO;
						SCALE_H;
						ANIM OFF;

						CYCLE
						{
							TACHYON_SHADER_RESOLUTION_LOW;
							TACHYON_SHADER_RESOLUTION_MEDIUM;
							TACHYON_SHADER_RESOLUTION_HIGH;
						};
					}

					BOOL TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
				}
				STATICTEXT TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_RESOLUTION_TEXT { ANIM OFF; }
				//----------------------------------------METALNESS SHADER END----------------------------------------

				LONG TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_CHANNEL_SELECTION 
				{
					NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
						TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
						TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
						TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
						TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
					};
				}

				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_BRIGHTNESS	{ NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_GAMMA	{ NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
				BOOL TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }

				REAL TACHYON_MATERIAL_REFLECTANCE_METALNESS_REFLECTANCE { UNIT PERCENT; MIN 0; MAX 100; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }
			}
		}

		GROUP TACHYON_MATERIALGROUP_GLOSSINESS
		{
			DEFAULT 1;
			LONG TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_ROUGH_SWITCH 
			{
			
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE 
				{
					TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_MODE;
					TACHYON_MATERIAL_REFLECTANCE_ROUGHNESS_MODE;
				};
			}

			REAL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_REFLECTANCE_ROUGHNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}

			SEPARATOR {}
			
			LONG TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_MODE
			{
				NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
				CYCLE
				{
					TACHYON_MATERIAL_MIX_MODE_BLEND;
					TACHYON_MATERIAL_MIX_MODE_ADD;
					//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
					TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
				}
			}
			REAL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

			//----------------------------------------SPECULAR GLOSSINESS SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------SPECULAR GLOSSINESS SHADER END----------------------------------------
			
			LONG TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_CHANNEL_SELECTION 
			{
				NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
				};
			}

			REAL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_CONTRAST { NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
			REAL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			BOOL TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
		}

		GROUP TACHYON_MATERIALGROUP_ENVIRONMENT
		{
			DEFAULT 1;
			BOOL TACHYON_MATERIAL_ENVIRONMENT_USE_GLOBAL { }
			REAL TACHYON_MATERIAL_ENVIRONMENT_EXPOSURE { CUSTOMGUI REALSLIDER; MIN 0.01; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 10.0; SCALE_H; }
		}

		GROUP TACHYON_MATERIALGROUP_REFLECTANCE_REFLECTIONS
		{
			DEFAULT 1;
			BOOL TACHYON_MATERIAL_REFLECTANCE_REFLECTION_ENABLED { }
			REAL TACHYON_MATERIAL_REFLECTANCE_SSR_EXPOSURE { CUSTOMGUI REALSLIDER; MIN 0.01; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 10.0; SCALE_H; }

			
			// tmp remove since definition of reflectivity changed due to pbr update
			//BOOL TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_PHYSICAL { NAME TACHYON_MATERIAL_OVERWRITE_PHYSICAL_VALUES; }
			//REAL TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_REFLECTIVITY { NAME TACHYON_MATERIAL_OVERWRITE_REFLECTIVITY; UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }
			//REAL TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_GLOSSINESS { NAME TACHYON_MATERIAL_OVERWRITE_GLOSSINESS; UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }
		}
	}

	GROUP TACHYON_MATERIALGROUP_TRANSPARENCY
	{
	 	DEFAULT 1;
		
		REAL TACHYON_MATERIAL_TRANSPARENCY_IOR { MIN 1.0; MAX 3.0; STEP 0.001; CUSTOMGUI REALSLIDER;  }
	 	BOOL TACHYON_MATERIAL_TRANSPARENCY_CAST_SHADOW { }

		GROUP TACHYON_MATERIALGROUP_TRANSPARENCY_OPACITY 
		{
			DEFAULT 1;
			REAL TACHYON_MATERIAL_TRANSPARENCY_AMOUNT { UNIT PERCENT; MIN 0.0; MAX 99.0; STEP 1.0; CUSTOMGUI REALSLIDER; }

			LONG TACHYON_MATERIAL_OPACITY_TEXTURE_MODE
	 		{
				NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
	 			CYCLE
	 			{
	 				TACHYON_MATERIAL_MIX_MODE_BLEND;
	 				TACHYON_MATERIAL_MIX_MODE_ADD;
	 				//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
	 				TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
	 			}
	 		}
	 		REAL TACHYON_MATERIAL_OPACITY_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

			//----------------------------------------OPACITY SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_OPACITY_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_OPACITY_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_OPACITY_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_OPACITY_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_OPACITY_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------OPACITY SHADER END----------------------------------------

			LONG TACHYON_MATERIAL_OPACITY_TEXTURE_CHANNEL_SELECTION 
			{
				NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
				};
			}

			REAL TACHYON_MATERIAL_OPACITY_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_OPACITY_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_OPACITY_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
	 		BOOL TACHYON_MATERIAL_OPACITY_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
			 
	 		SEPARATOR { LINE; }
		}
		

		GROUP TACHYON_MATERIALGROUP_TRANSPARENCY_TRANSMISSION 
		{
			DEFAULT 1;
			// BOOL TACHYON_MATERIAL_TRANSMISSIVE_APPLY_OPACITY { }
			COLOR TACHYON_MATERIAL_TRANSPARENCY_TRANSMISSION_COLOR { OPEN; }

	 		LONG TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_MODE
	 		{
				NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
	 			CYCLE
	 			{
	 				TACHYON_MATERIAL_MIX_MODE_BLEND;
	 				TACHYON_MATERIAL_MIX_MODE_ADD;
	 				//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
	 				TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
	 			}
	 		}
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

			//----------------------------------------TRANSPARENCY SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_TRANSPARENCY_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_TRANSPARENCY_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_TRANSPARENCY_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_TRANSPARENCY_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_TRANSPARENCY_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------TRANSPARENCY SHADER END----------------------------------------

	 		REAL TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
	 		BOOL TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
		}

	 	GROUP TACHYON_MATERIALGROUP_TRANSPARENCY_BLURRINESS
	 	{
	 		DEFAULT 1;
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }

	 		SEPARATOR {}

	 		LONG TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_MODE
	 		{
				NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
	 			CYCLE
	 			{
	 				TACHYON_MATERIAL_MIX_MODE_BLEND;
	 				TACHYON_MATERIAL_MIX_MODE_ADD;
	 				//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
	 				TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
	 			}
	 		}

	 		REAL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

			//----------------------------------------TRANSPARENCY_BLURRINESS SHADER----------------------------------------
			SHADERLINK TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
			GROUP
			{
				COLUMNS 3;

				BOOL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

				LONG TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_RESOLUTION
				{
					NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
					CUSTOMGUI QUICKTABRADIO;
					SCALE_H;
					ANIM OFF;

					CYCLE
					{
						TACHYON_SHADER_RESOLUTION_LOW;
						TACHYON_SHADER_RESOLUTION_MEDIUM;
						TACHYON_SHADER_RESOLUTION_HIGH;
					};
				}

				BOOL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
			}
			STATICTEXT TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_RESOLUTION_TEXT { ANIM OFF; }
			//----------------------------------------TRANSPARENCY_BLURRINESS SHADER END----------------------------------------

			LONG TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_CHANNEL_SELECTION 
			{
				NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
					TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
				};
			}

	 		REAL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_BRIGHTNESS	{ NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_CONTRAST { NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
	 		REAL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
	 		BOOL TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
		}
	}

	GROUP TACHYON_MATERIALGROUP_BUMP
	{
		REAL TACHYON_MATERIAL_BUMP_STRENGTH { UNIT PERCENT; MIN -1000.0; MAX 1000.0; STEP 1.0; MAXSLIDER 100.0; MINSLIDER -100.0; CUSTOMGUI REALSLIDER;}
		//LONG TACHYON_MATERIAL_BUMP_PARALLAX_OFFSET { STEP 1; MINSLIDER -100; MAXSLIDER 100; CUSTOMGUI LONGSLIDER; }
		//LONG TACHYON_MATERIAL_BUMP_PARALLAX_SAMPLES { MIN 2; MAX 10000; STEP 1; }

		//----------------------------------------BUMP SHADER----------------------------------------
		SHADERLINK TACHYON_MATERIAL_BUMP_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_MATERIAL_BUMP_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

			LONG TACHYON_MATERIAL_BUMP_SHADER_RESOLUTION
			{
				NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SHADER_RESOLUTION_LOW;
					TACHYON_SHADER_RESOLUTION_MEDIUM;
					TACHYON_SHADER_RESOLUTION_HIGH;
				};
			}

			BOOL TACHYON_MATERIAL_BUMP_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
		}
		STATICTEXT TACHYON_MATERIAL_BUMP_SHADER_RESOLUTION_TEXT { ANIM OFF; }
		//----------------------------------------BUMP SHADER END----------------------------------------
		
		LONG TACHYON_MATERIAL_BUMP_TEXTURE_CHANNEL_SELECTION 
		{
			NAME TACHYON_MATERIAL_TEXTURE_CHANEL_SELECTION;
			CUSTOMGUI QUICKTABRADIO;
			SCALE_H;
			ANIM OFF;

			CYCLE
			{
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
			};
		}

		REAL TACHYON_MATERIAL_BUMP_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_BUMP_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_BUMP_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		BOOL TACHYON_MATERIAL_BUMP_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
	}

	GROUP TACHYON_MATERIALGROUP_NORMAL
	{
		REAL TACHYON_MATERIAL_NORMAL_STRENGTH {UNIT PERCENT; MINSLIDER -100.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
		BOOL TACHYON_MATERIAL_NORMAL_FLIP_RED { }
		BOOL TACHYON_MATERIAL_NORMAL_FLIP_GREEN { }

		//----------------------------------------NORMAL SHADER----------------------------------------
		SHADERLINK TACHYON_MATERIAL_NORMAL_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_MATERIAL_NORMAL_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

			LONG TACHYON_MATERIAL_NORMAL_SHADER_RESOLUTION
			{
				NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SHADER_RESOLUTION_LOW;
					TACHYON_SHADER_RESOLUTION_MEDIUM;
					TACHYON_SHADER_RESOLUTION_HIGH;
				};
			}

			BOOL TACHYON_MATERIAL_NORMAL_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
		}
		STATICTEXT TACHYON_MATERIAL_NORMAL_SHADER_RESOLUTION_TEXT { ANIM OFF; }
		//----------------------------------------NORMAL SHADER END----------------------------------------
	}

	GROUP TACHYON_MATERIALGROUP_DISPLACEMENT
	{
		REAL TACHYON_MATERIAL_DISPLACEMENT_STRENGTH { CUSTOMGUI REALSLIDER; UNIT PERCENT; MIN -100.0; MAX 100.0; STEP 1.0; MINSLIDER -100.0; MAXSLIDER 100.0; }
		REAL TACHYON_MATERIAL_DISPLACEMENT_HEIGHT { }
		LONG TACHYON_MATERIAL_DISPLACEMENT_STEPS { MIN 1; MAX 64;}
        REAL TACHYON_MATERIAL_DISPLACEMENT_NORMAL_SMOOTHING { CUSTOMGUI REALSLIDER; UNIT PERCENT; MIN 1.0; MAX 500.0; STEP 1.0; MINSLIDER 1.0; MAXSLIDER 100.0; }
		LONG TACHYON_MATERIAL_DISPLACEMENT_TYPE
		{
			CYCLE
			{
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_INTENSITY;
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_INTENSITY_CENTERED;
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_REDGREEN;
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_TANGENT;
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_OBJECT_NORMAL;
				TACHYON_MATERIAL_DISPLACEMENT_TYPE_WORLD_NORMAL;
			}
		}

		//----------------------------------------DISPLACEMENT SHADER----------------------------------------
		SHADERLINK TACHYON_MATERIAL_DISPLACEMENT_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_MATERIAL_DISPLACEMENT_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

			LONG TACHYON_MATERIAL_DISPLACEMENT_SHADER_RESOLUTION
			{
				NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SHADER_RESOLUTION_LOW;
					TACHYON_SHADER_RESOLUTION_MEDIUM;
					TACHYON_SHADER_RESOLUTION_HIGH;
				};
			}

			BOOL TACHYON_MATERIAL_DISPLACEMENT_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
		}
		STATICTEXT TACHYON_MATERIAL_DISPLACEMENT_SHADER_RESOLUTION_TEXT { ANIM OFF; }
		//----------------------------------------DISPLACEMENT SHADER END----------------------------------------

        REAL TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
        REAL TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
        REAL TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
        BOOL TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
	}

	GROUP TACHYON_MATERIALGROUP_EMISSIVE
	{
		COLOR TACHYON_MATERIAL_EMISSIVE_COLOR { OPEN; }
		REAL TACHYON_MATERIAL_EMISSIVE_BRIGHTNESS { UNIT PERCENT; MIN 0.0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 500.0; }

		SEPARATOR {}

        LONG TACHYON_MATERIAL_EMISSIVE_TEXTURE_MODE
	 	{
			NAME TACHYON_MATERIAL_TEXTURE_BLEND_MODE;
	 		CYCLE
	 		{
	 			TACHYON_MATERIAL_MIX_MODE_BLEND;
	 			TACHYON_MATERIAL_MIX_MODE_ADD;
	 			//TACHYON_MATERIAL_MIX_MODE_SUBTRACT;
	 			TACHYON_MATERIAL_MIX_MODE_MULTIPLY;
	 		}
	 	}
	 	REAL TACHYON_MATERIAL_EMISSIVE_TEXTURE_STRENGTH { NAME TACHYON_MATERIAL_TEXTURE_BLEND_AMOUNT; UNIT PERCENT; MIN 0; MAX 100; STEP 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}

		//----------------------------------------EMISSIVE SHADER----------------------------------------
		SHADERLINK TACHYON_MATERIAL_EMISSIVE_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_MATERIAL_EMISSIVE_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

			LONG TACHYON_MATERIAL_EMISSIVE_SHADER_RESOLUTION
			{
				NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SHADER_RESOLUTION_LOW;
					TACHYON_SHADER_RESOLUTION_MEDIUM;
					TACHYON_SHADER_RESOLUTION_HIGH;
				};
			}

			BOOL TACHYON_MATERIAL_EMISSIVE_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
		}
		STATICTEXT TACHYON_MATERIAL_EMISSIVE_SHADER_RESOLUTION_TEXT { ANIM OFF; }
		//----------------------------------------EMISSIVE SHADER END----------------------------------------

		REAL TACHYON_MATERIAL_EMISSIVE_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_EMISSIVE_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_EMISSIVE_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		BOOL TACHYON_MATERIAL_EMISSIVE_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
	}

	//GROUP TACHYON_MATERIALGROUP_ENVIRONMENT
	//{
		//DEFAULT 1;
		//BOOL TACHYON_MATERIAL_ENVIRONMENT_USE_GLOBAL { }
		//REAL TACHYON_MATERIAL_ENVIRONMENT_ROTATION { UNIT DEGREE; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER -180.0; MAXSLIDER 180.0; }

		//SEPARATOR {}

		//TEXTURE TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_HREF { OPEN; }
		//REAL TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_BRIGHTNESS { UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		//REAL TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_CONTRAST { UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		//REAL TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_GAMMA { MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER;}
		
		//GROUP TACHYON_MATERIALGROUP_ENVIRONMENT_OVERRIDE
		//{
		//	DEFAULT 1;
		//	BOOL TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_PHYSICAL { }
		//	REAL TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_REFLECTIVITY { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }
		//	REAL TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_GLOSSINESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }
		//}
	//}

	GROUP TACHYON_MATERIALGROUP_MASK
	{
		DEFAULT 1;

		REAL TACHYON_MATERIAL_MASK_THRESHOLD { MIN 0.0; STEP 0.01; MAX 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 1.0; }
		LONG TACHYON_MATERIAL_MASK_CHANNEL_SELECTION 
		{
			CUSTOMGUI QUICKTABRADIO;
			SCALE_H;
			ANIM OFF;

			CYCLE
			{
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA;
				TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE;
			};
		}

		//----------------------------------------MASK SHADER----------------------------------------
		SHADERLINK TACHYON_MATERIAL_MASK_SHADER_HREF { NAME TACHYON_MATERIAL_SHADER_HREF; }
		GROUP
		{
			COLUMNS 3;

			BOOL TACHYON_MATERIAL_MASK_SHADER_ANIM_ENABLED { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_ANIM_ENABLED; }

			LONG TACHYON_MATERIAL_MASK_SHADER_RESOLUTION
			{
				NAME TACHYON_MATERIAL_SHADER_RESOLUTION;
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SHADER_RESOLUTION_LOW;
					TACHYON_SHADER_RESOLUTION_MEDIUM;
					TACHYON_SHADER_RESOLUTION_HIGH;
				};
			}

			BOOL TACHYON_MATERIAL_MASK_SHADER_USE_SRC_RES { ANIM OFF; NAME TACHYON_MATERIAL_SHADER_USE_SRC_RES; }
		}
		STATICTEXT TACHYON_MATERIAL_MASK_SHADER_RESOLUTION_TEXT { ANIM OFF; }
		//----------------------------------------MASK SHADER END -----------------------------------

		REAL TACHYON_MATERIAL_MASK_TEXTURE_BRIGHTNESS { NAME TACHYON_MATERIAL_TEXTURE_BRIGHTNESS; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_MASK_TEXTURE_CONTRAST	{ NAME TACHYON_MATERIAL_TEXTURE_CONTRAST; UNIT PERCENT; MIN -100; MAX 100; STEP 1.0; CUSTOMGUI REALSLIDER;}
		REAL TACHYON_MATERIAL_MASK_TEXTURE_GAMMA { NAME TACHYON_MATERIAL_TEXTURE_GAMMA; MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		BOOL TACHYON_MATERIAL_MASK_TEXTURE_INVERT { NAME TACHYON_MATERIAL_TEXTURE_INVERT; }
	}

	INCLUDE Massign;
}
